truncate table items, packages, locations, customers, drivers, transports, connections, segments restart identity cascade;
---- pomocne tabulky na generovanie dat

-- male first names
drop table if exists male_first_names cascade;
create table male_first_names(
    first_name varchar
);

insert into male_first_names (first_name)
values	('Drahoslav'), ('Rastislav'), ('Dalibor'), ('Vincent'), ('Miloš'),
	    ('Timotej'), ('Emil'), ('Erik'), ('Zdenko'), ('Valentín'),
	    ('Róbert'), ('Roman'), ('Jaromír'), ('Matej'), ('Viktor'),
	    ('Radoslav'), ('Tomáš'), ('Alexander'), ('Adrián'), ('Gabriel'),
	    ('Marián'), ('Igor'), ('Marcel'), ('Richard'), ('Juraj'),
	    ('Marek'), ('Ladislav'), ('Peter'), ('Pavol'), ('Jakub'),
        ('Dominik'), ('Oskar'), ('Lukáš'), ('Adam'), ('Andrej');

-- female first names
drop table if exists female_first_names cascade;
create table female_first_names(
    first_name varchar
);

insert into female_first_names (first_name)
values	('Alexandra'), ('Daniela'), ('Andrea'), ('Zora'), ('Ema'),
        ('Tatiana'), ('Veronika'), ('Gabriela'), ('Lívia'), ('Zlatica'),
        ('Alena'), ('Soňa'), ('Žofia'), ('Júlia'), ('Iveta'),
        ('Lucia'), ('Lenka'), ('Laura'), ('Karolína'), ('Stanislava'),
        ('Beáta'), ('Petra'), ('Diana'), ('Nina'), ('Magdaléna'),
        ('Dominika'), ('Marta'), ('Nora'), ('Silvia'), ('Ružena'),
        ('Terézia'), ('Natália'), ('Klára'), ('Simona'), ('Eva');

-- male second names
drop table if exists male_second_names cascade;
create table male_second_names(
    second_name varchar
);

insert into  male_second_names (second_name)
values	('Adamec'), ('Andráš'), ('Baláž'), ('Bača'), ('Blaha'),
	    ('Bosák'), ('Cibuľa'), ('Cíger'), ('Dula'), ('Daňo'),
	    ('Ďurovič'), ('Dvonč'), ('Eliáš'), ('Egry'), ('Fabian'),
	    ('Fránek'), ('Ftorek'), ('Gál'), ('Galik'), ('Grňa'),
	    ('Gašpar'), ('Halák'), ('Haluška'), ('Hlaváček'), ('Hladký'),
	    ('Hošták'), ('Hudáček'), ('Chudík'), ('Chovanec'), ('Ihnačák'),
	    ('Jakab'), ('Jalovec'), ('Kazík'), ('Klaus'), ('Klimkovič'),
	    ('Kováč'), ('Lipták'), ('Loj'), ('Mácha'), ('Macák'),
	    ('Markovič'), ('Nagy'), ('Nemec'), ('Ondrák'), ('Novák'),
	    ('Orság'), ('Pajger'), ('Palkovič'), ('Paška'), ('Richtár'),
        ('Roháček'), ('Rusnák'), ('Sklenárik'), ('Sabo'), ('Sagan'),
        ('Šulc'), ('Ťapák'), ('Toman'), ('Urblík'), ('Vajda'),
        ('Vavrinský'), ('Vondráček'), ('Weiss'), ('Záborský'), ('Železnik');

-- female second names
drop table if exists female_second_names cascade;
create table female_second_names(
    second_name varchar
);

insert into  female_second_names (second_name)
values	('Adamcová'), ('Andrášová'), ('Balážová'), ('Bačová'), ('Blahová'),
        ('Bosáková'), ('Cibuľová'), ('Cígerová'), ('Dulová'), ('Daňová'),
        ('Ďurovičová'), ('Dvončová'), ('Eliášová'), ('Egryová'), ('Fabianová'),
        ('Fráneková'), ('Ftorková'), ('Gálová'), ('Galiková'), ('Grňová'),
        ('Gašparová'), ('Haláková'), ('Halušková'), ('Hlaváčková'), ('Hladká'),
        ('Hoštáková'), ('Hudáčková'), ('Chudíková'), ('Chovancová'), ('Ihnačáková'),
        ('Jakabová'), ('Jalovcová'), ('Kazíková'), ('Klausová'), ('Klimkovičová'),
        ('Kováčová'), ('Liptáková'), ('Lojová'), ('Máchová'), ('Macáková'),
        ('Markovičová'), ('Nagyová'), ('Nemcová'), ('Ondráková'), ('Nováková'),
        ('Orságová'), ('Pajgerová'), ('Palkovičová'), ('Pašková'), ('Richtárová'),
        ('Roháčková'), ('Rusnáková'), ('Sklenáriková'), ('Saboová'), ('Saganová'),
        ('Šulcová'), ('Ťapáková'), ('Tomanová'), ('Urblíková'), ('Vajdová'),
        ('Vavrinská'), ('Vondráčková'), ('Weissová'), ('Záborská'), ('Železniková');

--LOCATIONS
alter sequence locations_id_seq restart with 1;
insert into locations (name)
values ('Banská Bystrica'), ('Bratislava'),('Brezno'), ('Bytča'), ('Čadca'),
       ('Dolný Kubín'), ('Dunajská Streda'), ('Gelnica'), ('Hlohovec'),
       ('Humenné'), ('Kežmarok'), ('Komárno'), ('Košice'), ('Krupina'),
       ('Kysucké Nové Mesto'), ('Liptovský Mikuláš'), ('Lučenec'), ('Malacky'), ('Martin'),
       ('Medzilaborce'), ('Michalovce'), ('Myjava'), ('Nitra'), ('Nové Mesto nad Váhom'),
       ('Nové Zámky'), ('Partizánske'), ('Pezinok'), ('Piešťany'), ('Poprad'),
       ('Považská Bystrica'), ('Prešov'), ('Prievidza'), ('Púchov'), ('Rimavská Sobota'),
       ('Ružomberok'), ('Sabinov'), ('Senec'), ('Sobrance'), ('Spišská Nová Ves'),
       ('Topoľčany'), ('Trenčín'), ('Trnava'), ('Turčianske Teplice'), ('Tvrdošín'),
       ('Veľký Krtíš'), ('Zlaté Moravce'), ('Zvolen'),  ('Žiar nad Hronom'), ('Žilina');

--CONNECTIONS
alter sequence connections_id_seq restart with 1;
insert into connections (loca_id, locb_id)
values (1, 2), (1, 8), (2, 1), (2, 3), (2, 9), (3, 2), (3, 4), (3, 10),
       (4, 3), (4, 5), (4, 11), (5, 4), (5, 6), (5, 12), (6, 5), (6, 7), (6, 13),
       (7, 6), (7, 14), (8, 9), (8, 15), (8, 1), (9, 8), (9, 10), (9, 16), (9, 2),
       (10, 9), (10, 11), (10, 17), (10, 3), (11, 10), (11, 12), (11, 18), (11, 4),
       (12, 11), (12, 13), (12, 19), (12, 5), (13, 12), (13, 14), (13, 20), (13, 6),
       (14, 13), (14, 21), (14, 7), (15, 16), (15, 22), (15, 8), (16, 15), (16, 17),
       (16, 23), (16, 9), (17, 16), (17, 18), (17, 24), (17, 10), (18, 17), (18, 19),
       (18, 25), (18, 11), (19, 18), (19, 20), (19, 26), (19, 12), (20, 19), (20, 21),
       (20, 27), (20, 13), (21, 20), (21, 28), (21, 14), (22, 23), (22, 29), (22, 15),
       (23, 22), (23, 24), (23, 30), (23, 16), (24, 23), (24, 25), (24, 31), (24, 17),
       (25, 24), (25, 26), (25, 32), (25, 18), (26, 25), (26, 27), (26, 33), (26, 19),
       (27, 26), (27, 28), (27, 34), (27, 20), (28, 27), (28, 35), (28, 21), (29, 30),
       (29, 36), (29, 22), (30, 29), (30, 31), (30, 37), (30, 23), (31, 30), (31, 32),
       (31, 38), (31, 24), (32, 31), (32, 33), (32, 39), (32, 25), (33, 32), (33, 34),
       (33, 40), (33, 26), (34, 33), (34, 35), (34, 41), (34, 27), (35, 34), (35, 42),
       (35, 28), (36, 37), (36, 43), (36, 29), (37, 36), (37, 38), (37, 44), (37, 30),
       (38, 37), (38, 39), (38, 45), (38, 31), (39, 38), (39, 40), (39, 46), (39, 32),
       (40, 39), (40, 41), (40, 47), (40, 33), (41, 40), (41, 42), (41, 48), (41, 34),
       (42, 41), (42, 49), (42, 35), (43, 44), (43, 36), (44, 43), (44, 45), (44, 37),
       (45, 44), (45, 46), (45, 38), (46, 45), (46, 47), (46, 39), (47, 46), (47, 48),
       (47, 40), (48, 47), (48, 49), (48, 41), (49, 48), (49, 42);

--FUNCTIONS--TEMPORARY
create or replace function random_male_first_name() returns varchar language sql as $$
select first_name from male_first_names order by random() limit 1
$$;

create or replace function random_female_first_name() returns varchar language sql as $$
select first_name from female_first_names  order by random() limit 1
$$;

create or replace function random_male_second_name() returns varchar language sql as $$
select second_name from male_second_names  order by random() limit 1
$$;

create or replace function random_female_second_name() returns varchar language sql as $$
select second_name from female_second_names order by random() limit 1
$$;

create or replace function random_location_id() returns integer language sql as $$
select id from locations order by random() limit 1
$$;

create or replace function random_package_id() returns integer language sql as $$
select id from packages tablesample system_rows(100) order by random() limit 1
$$;

create or replace function random_transport_id() returns integer language sql as $$
select id from transports tablesample system_rows(100) order by random() limit 1
$$;

--FUNCTIONS--EVERLASTING
create or replace function customer_location_id(cus_id int) returns integer language sql as $$
SELECT location_id FROM customers WHERE id = cus_id
$$;

create or replace function location_name(loc_id integer) returns varchar language sql as $$
SELECT name from locations where id = loc_id;
$$;

create or replace function path_finder(start int, finish int) returns int ARRAY LANGUAGE SQL as
$$
WITH RECURSIVE paths(src,dst,path) AS (
    SELECT e.loca_id, e.locb_id, ARRAY[e.loca_id,e.locb_id]
    FROM connections e where  e.loca_id = start and start != finish
    UNION
    SELECT p.src, e.locb_id, p.path || ARRAY[e.locb_id]
    FROM paths p JOIN connections e ON p.dst = e.loca_id AND e.locb_id != ALL(p.path)
)
SELECT path FROM paths where dst = finish limit 1;
$$;

create or replace function stats(year_or_quad varchar, rank int, if_month int = 1) returns table(t timestamp with time zone, loc_name varchar, count bigint) language sql as
$$
SELECT current_timestamp - (rank || year_or_quad)::interval,
       location_name(c.loca_id) as location_name, count(*) FROM segments s join connections c on s.connection_id = c.id
where accident = false and
        time >  current_timestamp - (if_month*rank || year_or_quad)::interval and
        time <= current_timestamp - (if_month*(rank-1) || year_or_quad)::interval
group by c.loca_id order by count(*) desc limit 3
$$;

--TEMP--ALL POSSIBLE PATHS
drop table if exists all_paths;
create table all_paths as
select p.i as a,
       q.j as b,
       path_finder(p.i, q.j) as r
from generate_series(1,49) as p(i) cross join generate_series(1,49) as q(j);

--CUSTOMERS
alter sequence customers_id_seq restart with 1;
insert into customers (first_name, second_name, reachable, location_id)
select	case (i % 2)  when 1 then random_female_first_name() else random_male_first_name() end  as first_name,
        case (i % 2)  when 1 then random_female_second_name() else random_male_second_name() end  as second_name,
        case floor(random() * 4) when 0 then false else true end as reachable,
        floor(random() * 49 + 1) as location_id
from generate_series(1, 200000) as seq(i);

--DRIVERS
alter sequence drivers_id_seq restart with 1;
insert into drivers (first_name, second_name, hire_date, salary, initial_salary, delivered_packages, location_id, transport_id)
select case (i % 6)  when 5 then random_female_first_name() else random_male_first_name() end  as first_name,
       case (i % 6)  when 5 then random_female_second_name() else random_male_second_name() end  as second_name,
       current_date as hire_date,
       1000 as salary,
       1000 as initial_salary,
       0 as delivered_packages,
       random_location_id() as location_id,
       null as transport_id
from generate_series(1, 500) as seq(i);

--PACKAGES
alter sequence packages_id_seq restart with 1;
insert into packages (insurance, delivery_price, status, delivery_attempts, damage, sender_id, recipient_id)
select case floor(random() * 3) when 0 then false else true end as insurance,
            null as delivery_price,
            e.state as status,
            case e.state when 'company_failed' then 6 when 'delivered' then floor(random()*5+1) else 0 end as delivery_attempts,
            case e.state when 'damaged' then 100 else e.dam end as damage,
            e.sender as sender_id,
            case e.reciver when e.sender then floor(random() * 100000 + 1) else e.reciver end as recipient_id
from (select floor(random() * 200000 + 1) as sender,
             floor(random() * 200000 + 1) as reciver,
             case floor(random() * 100) when 0 then floor(random() * 99 + 1) else 0 end as dam,
             case floor(random() * 25) when 0 then 'ready' when 1 then 'ready' when 2 then 'ready' when 3 then 'ready' when 4 then 'ready'
                                       when 5 then 'damaged'
                                       when 6 then 'company_failed' else 'delivered' end as state
        from generate_series(1, 500000) as seq(i)) as e;

--ITEMS
alter sequence items_id_seq restart with 1;
insert into items (name, weight, price, uninsured_ratio, package_id)
select 'item ' || i as name,
       floor(random() * 100) as weight,
       floor(random() * 1000 + 1) as price,
       floor(random() * 90 + 11) as uninsured_ratio,
       case floor(random() * 5) when 0 then null else floor(random()* 500000 + 1) end as package_id
from generate_series(1, 1000000) as seq(i);

drop index if exists i;
create index i on items(package_id);
cluster items using i;
update packages p set delivery_price = (SELECT sum(weight) FROM items WHERE package_id = p.id) where 1 = 1;
update packages p set delivery_attempts = 0, status = 'new' where delivery_price is null;

--TRANSPORTS
alter sequence transports_id_seq restart with 1;
insert into transports(route, departure_time, arrival_time, package_id, starting_loc_id, destination_loc_id)
select --path_finder(send, rec) as route,
       (select r from all_paths where a = send and b = rec limit 1) as route,
       p.tm as departure_time,
       p.tm + (floor(random()*518400 + 86400)||' seconds')::interval as arrival_time,
       p.id as package_id,
       send as starting_loc_id,
       rec as destination_loc_id
from (select *, timestamp'2010-01-01 01:00:00' +  (floor(random()*315360000) ||' seconds')::interval as tm,
        customer_location_id(packages.sender_id) as send,
        customer_location_id(packages.recipient_id) as rec
        from packages where status != 'new') as p;

--SEGMENTS
alter sequence segments_id_seq restart with 1;
insert into segments(transport_id, connection_id, accident, damage, time)
select random_transport_id() as transport_id,
       floor(random() * 168 + 1) as connection_id,
       aa.accident as accident,
       case aa.accident when true then floor(random() * 100 + 1) else 0 end as damage,
       timestamp'2010-01-01 01:00:00' + (floor(random()*315360000) ||' seconds')::interval as time
from (select case floor(random() * 50) when 5 then true else false end as accident from generate_series(1,1000000) as seq(i)) as aa;

drop table male_first_names, female_first_names, male_second_names, female_second_names, all_paths cascade;

drop function random_male_first_name();
drop function random_male_second_name();
drop function random_female_first_name();
drop function random_female_second_name();
drop function random_location_id();
drop function random_package_id();
drop function random_transport_id();